/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.ArrayNodeDiff;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.Column;
import org.autoplot.dom.Connector;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotController;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PropertyChangeDiff;
import org.autoplot.dom.Row;
import org.das2.util.LoggerManager;

public class ApplicationControllerSyncSupport {
    ApplicationController controller;
    Application application;
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom");

    ApplicationControllerSyncSupport(ApplicationController controller) {
        this.controller = controller;
        this.application = controller.application;
    }

    protected void syncToCanvases(Canvas[] canvases, Map<String, String> layoutIds) {
        if (canvases.length != this.application.canvases.size()) {
            throw new IllegalArgumentException("not implemented");
        }
        for (int i = 0; i < canvases.length; ++i) {
            this.application.canvases.get((int)i).controller.syncTo(canvases[i], new ArrayList<String>(), layoutIds);
        }
    }

    protected void syncToPlotElements(PlotElement[] elements, Map<String, String> nameMap) {
        int i;
        while (this.application.plotElements.size() < elements.length) {
            i = this.application.plotElements.size();
            String idd = elements[i].getPlotId();
            Plot p = null;
            for (int j = 0; j < this.application.getPlots().length; ++j) {
                if (!this.application.getPlots(j).getId().equals(idd)) continue;
                p = this.application.getPlots(j);
            }
            DataSourceFilter dsf = null;
            for (int j = 0; j < this.application.getDataSourceFilters().length; ++j) {
                if (!this.application.getDataSourceFilters(j).getId().equals(elements[i].getDataSourceFilterId())) continue;
                dsf = this.application.getDataSourceFilters(j);
            }
            this.controller.addPlotElement(p, dsf);
        }
        while (this.application.plotElements.size() > elements.length && elements.length > 0) {
            this.controller.deletePlotElement(this.application.plotElements.get(this.application.plotElements.size() - 1));
        }
        for (i = 0; i < elements.length; ++i) {
            this.application.plotElements.get(i).syncTo(elements[i], Arrays.asList("plotId", "dataSourceFilterId", "renderType", "style", "renderControl"));
            this.application.plotElements.get(i).setPlotId(nameMap.get(elements[i].getPlotId()));
            this.application.plotElements.get(i).setRenderType(elements[i].getRenderType());
            this.application.plotElements.get(i).setAutoRenderType(elements[i].isAutoRenderType());
            this.application.plotElements.get(i).getController().maybeCreateDasPeer();
            this.application.plotElements.get(i).getController().setResetRanges(false);
            this.application.plotElements.get(i).getController().setDsfReset(false);
            this.application.plotElements.get(i).setRenderControl(elements[i].getRenderControl());
            this.application.plotElements.get(i).getStyle().syncTo(elements[i].getStyle());
            this.application.plotElements.get(i).setDataSourceFilterId(nameMap.get(elements[i].getDataSourceFilterId()));
            this.application.plotElements.get(i).getController().setResetPlotElement(false);
        }
    }

    protected void syncToPlots(Plot[] plots, Map<String, String> nameMap) {
        List<Diff> diffs = DomUtil.getArrayDiffs("plots", plots, this.application.getPlots());
        for (Diff d : diffs) {
            ArrayNodeDiff and;
            if (d instanceof ArrayNodeDiff && (and = (ArrayNodeDiff)d).getAction() == ArrayNodeDiff.Action.Delete) {
                Plot domPlot = (Plot)and.getNode();
                List<PlotElement> eles = this.controller.getPlotElementsFor(domPlot);
                if (domPlot.controller != null) {
                    domPlot.controller.deleteDasPeer();
                }
                this.controller.unbind(domPlot);
                this.controller.unbind(domPlot.getXaxis());
                this.controller.unbind(domPlot.getYaxis());
                this.controller.unbind(domPlot.getZaxis());
                for (PlotElement pe : eles) {
                    domPlot.controller.removePlotElement(pe);
                    pe.plotId = "";
                    pe.getController().renderer = null;
                    pe.getController().setResetPlotElement(true);
                }
            }
            if (d instanceof PropertyChangeDiff) continue;
            d.doDiff(this.application);
        }
        for (int i = 0; i < this.application.getPlots().length; ++i) {
            this.application.getPlots(i).syncTo(plots[i]);
        }
        for (Plot p : this.application.getPlots()) {
            if (p.controller == null) {
                Column col;
                Row row;
                if (p.getRowId().equals("")) {
                    row = this.application.controller.getCanvas().marginRow;
                } else {
                    row = (Row)DomUtil.getElementById(this.application, p.getRowId());
                    if (row == null) {
                        row = this.application.controller.getCanvas().marginRow;
                    }
                }
                if (p.getColumnId().equals("")) {
                    col = this.application.controller.getCanvas().marginColumn;
                } else {
                    col = (Column)DomUtil.getElementById(this.application, p.getColumnId());
                    if (col == null) {
                        col = this.application.controller.getCanvas().marginColumn;
                    }
                }
                logger.log(Level.FINE, "adding controller for new node {0}", p);
                PlotController pc = new PlotController(this.application, p);
                Row frow = row;
                Column fcol = col;
                pc.createDasPeer(frow.controller.getCanvas(), frow, fcol);
                if (SwingUtilities.isEventDispatchThread()) {
                    logger.finer("sync called on event thread");
                }
            }
            nameMap.put(p.getId(), p.getId());
        }
    }

    protected void syncConnectors(Connector[] connectors) {
        ArrayList<Connector> addConnectors = new ArrayList<Connector>();
        ArrayList<Connector> deleteConnectors = new ArrayList<Connector>();
        List<Connector> thisConnectors = Arrays.asList(this.application.getConnectors());
        List<Connector> thatConnectors = Arrays.asList(connectors);
        for (Connector c : thatConnectors) {
            if (thisConnectors.contains(c)) continue;
            addConnectors.add(c);
        }
        for (Connector c : this.application.connectors) {
            if (thatConnectors.contains(c)) continue;
            deleteConnectors.add(c);
        }
        for (Connector c : addConnectors) {
            Plot plotA = (Plot)DomUtil.getElementById(this.application, c.plotA);
            Plot plotB = (Plot)DomUtil.getElementById(this.application, c.plotB);
            this.controller.addConnector(plotA, plotB);
        }
        for (Connector c : deleteConnectors) {
            this.controller.deleteConnector(c);
        }
        for (int i = 0; i < connectors.length; ++i) {
            this.application.connectors.get(i).syncTo(connectors[i]);
        }
    }

    protected void syncAnnotations(Annotation[] annotations) {
        while (this.application.annotations.size() < annotations.length) {
            this.controller.addAnnotation(new Annotation());
        }
        while (this.application.annotations.size() > annotations.length) {
            this.controller.deleteAnnotation(this.application.annotations.get(this.application.annotations.size() - 1));
        }
        for (int i = 0; i < annotations.length; ++i) {
            this.application.annotations.get(i).syncTo(annotations[i]);
        }
    }

    protected void syncBindings(BindingModel[] bindings, Map<String, String> idMap) {
        List<Diff> diffs = DomUtil.getArrayDiffs("bindings", bindings, this.application.getBindings());
        for (Diff d : diffs) {
            if (d instanceof ArrayNodeDiff) {
                ArrayNodeDiff and = (ArrayNodeDiff)d;
                if (and.getAction() == ArrayNodeDiff.Action.Delete) {
                    BindingModel domBinding = (BindingModel)and.getNode();
                    this.controller.removeBinding(domBinding);
                }
                if (and.getAction() != ArrayNodeDiff.Action.Insert) continue;
                BindingModel c = (BindingModel)and.getNode();
                DomNode src = DomUtil.getElementById(this.application, idMap.get(c.srcId));
                DomNode dst = DomUtil.getElementById(this.application, idMap.get(c.dstId));
                if (src == null || dst == null) {
                    logger.info("src or dst was null");
                    continue;
                }
                try {
                    this.controller.bind(src, c.srcProperty, dst, c.dstProperty);
                }
                catch (IllegalArgumentException ex) {
                    logger.log(Level.INFO, "unable to bind property: {0}", ex);
                }
                continue;
            }
            d.doDiff(this.application);
        }
    }

    protected void syncBindings(BindingModel[] bindings) {
        this.syncBindings(bindings, new HashMap<String, String>());
    }

    protected void syncToDataSourceFilters(DataSourceFilter[] dataSourceFilters, Map<String, String> nameMap) {
        while (this.application.dataSourceFilters.size() < dataSourceFilters.length) {
            this.controller.addDataSourceFilter();
        }
        while (this.application.dataSourceFilters.size() > dataSourceFilters.length) {
            int n = this.application.dataSourceFilters.size();
            DataSourceFilter dsf = this.application.dataSourceFilters.get(n - 1);
            List<PlotElement> elements = this.controller.getPlotElementsFor(dsf);
            for (PlotElement element : elements) {
                element.setDataSourceFilterId("");
            }
            if (this.application.dataSourceFilters.size() != n) continue;
            DataSourceFilter[] dsfs = this.application.getDataSourceFilters();
            this.application.setDataSourceFilters(Arrays.copyOf(dsfs, n - 1));
        }
        for (int i = 0; i < dataSourceFilters.length; ++i) {
            this.application.dataSourceFilters.get(i).syncTo(dataSourceFilters[i]);
            nameMap.put(dataSourceFilters[i].getId(), this.application.dataSourceFilters.get(i).getId());
        }
    }
}

